
/** 
 * @author  gWahl 
 * @version 2010-05-05
 * 
 * Defining the ReminderFox Navigation Menu layout.
 * The 'Navigation Menu' as shown on screen is defined by an array.
 * 
 * Structure of the array:   
 *          *([language, 
 *              [menu, LanguageLabel, tooltext],
 *              [gSearch, Label for GoogleSearch, tooltext]
 *              [menuString]
 *           ])
 * 
 *    menuString:  *(,[item, title, tooltext *(,menuString)])
 * 
 *    Notes: 
 *     --  'menuString' with 4 parameters are handled as submenus
 *     --  'menuString' 'item's with leading '<' will be opened by default
 *     --  'item's for submenus have to be unique, not to be the same for 
 *          different language arrays.
 * 
 *    Handling of special 'item' for:
 *       - br      insert separator
 *       - hr      insert horizontal line
 */ 


var sectionSetup = [        
     
  ["en", 
      ["menu",        "English", "ReminderFox-Info pages - English speaking"],
      ["gSearch",     "Search ReminderFox", "Use Google Search to lookup ReminderFox pages."],

      ["overview",    "Overview", "A brief overview of what ReminderFox can do for you."],
	      
      ["<UserGuide",     "User Guide", "Detailed explanations of all of ReminderFox's functions.",
         [  ["events",      "Events", "Reminders with a date/time"],       
            ["todos",       "ToDo's", "Tasks that may or may not have a specific start date or completion date"],
            ["extras",      "Special Events", "Tasks for WEB pages, mails and entries in the addressbook"],
            ["list",        "List of events and todo's", "Showing and working with reminders, filter/search functions"],
            ["notification","Notifications", "Get signaled for events"],
	
            ["<mail",        "Mail Support", "ReminderFox supports information with the mail system", 
               [  ["mail#mail",        " Reminder with messages", "Reminderfox tracs messages"],
                  ["mail#mailFollow",  " Message workflow", "Use Reminderfox keep track of replies"],
                  ["extras#ABentry",   " Contacts", "Add reminder for contacts in address book / cards"],
                  ['hr']
               ]
            ],
	
            ["ical",        "Invitations  [iCal / iTIP]", "Send/Receive and process invitations"],
            ["exchanging",  "Sharing Reminders", "Exchange reminders with other calendars and devices"],
            ["gcalsync",  "GCalendar sync", "How to sync GoogleCalendar and ReminderFox."]
         ]
      ],

      ["videos",   "Videos", "See ReminderFox in action.",
         [  ["videos#overview1",  "Overview", "Get a general overview of ReminderFox"],
            ["videos#overview2",  "Filtering, Todos", "Filtering reminders for better overview"],
            ["videos#overview3",  "Alerts, Alarms, Views", "How ReminderFox works with your Events and Todos"]
         ]
      ],
      
      ["HowTo",   "How to", "Notes about using, changing features and preferences",
         [  ["options#userinterface",  "User Interface", "Menus and Toolbars"],
            ["options#options",        "Options", "Customize the ReminderFox installation"],
            ["options#preferences",    "Preferences", "Advanced Feature Info"]
         ]
      ],
      ['hr'],
      
      ["faqdetails",  "FAQ", "Some of the most commonly asked questions."],      
      
      ["Troubleshooting",        "Troubleshooting", "Help to some common issues.",
         [  ["problems",            "Questions", "Find answers to some common issues"],
            ["problems#deinstall",  "Uninstall ReminderFox", "How to completely uninstall?"]
         ]
      ],

      ["http://reminderfox.mozdev.org/list.html",   "ReminderFox List", "Use the ReminderFox list to ask more questions."],
  ],
     
  ["de", 
      ["menu",       "Deutsch", "ReminderFox-Info - Deutsche Seiten"], 
      ["gSearch",    "Suchen auf ReminderFox", "Inhalte finden mit Google Suchfunktion"],

      ["overview",   "&Uuml;bersicht", "Ein Kurz&uuml;berblick aller Funktionsbereiche"],


      ["<Bedienung",  "Bedienung",      "Erl&auml;uterung der einzelnen Funktionen",
         [  ["events",      "Termine",    "Ereignisse mit Datum/Zeit"],         
            ["todos",       "Aufgaben",   "Aufgaben"],
            ["extras",      "Besondere Ereignisse",  "Erinnerungen f&uuml;r WEB-Seiten, E-Mails und Adressbuch"],     
            ["list",        "Liste f&uuml;r Termine/Aufgaben", "Anzeigen und Bearbeiten der Erinnerungen, Such- und Filterfunktionen"],
            ["notification","Benachrichtungen ",  "Benachrichtung / Meldung / Alarm"],  

            ["email",    "E-Mail Unterst&uuml;tzung", "Erinnerungen f&uuml;r E-Mail und mehr ..",
               [  ["mail#mail",       "Erinnerungen mit E-Mail", "Erinnerungen f&uuml;r E-Mails zur Wiedervorlage"],
                  ["mail#mailFollow",  "Mail-Vorgangsverfolgung", "Verfolgen von Sendungen und Antworten"],
                  ["extras#ABentry",   "Kontakte", "Erinnerung f&uuml;r Kontakte im Adressbuch"],
                  ['hr']
               ]
            ],

            ["ical",        "Einladungen  [iCal / iTIP]",  "Senden/Empfangen von Einladungen"], 
            ["exchanging",  "Austauschen von Terminen und Aufgaben",  "ReminderFox Erinnerungen mit anderen Kalendern und Ger&auml;ten austauschen"],
            ["gcalsync",  "GCalendar sync", "Synchronisation von GoogleCalendar und ReminderFox."]
         ],
      
         ["Wie", "Einstellungen und Anpassungen",  "Erweiterte Bedienung, Benutzeranpassung und Voreinstellungen",
            [  ["options#userinterface",   "Men&uuml; Funktionen",   "Aufrufe verschiedener ReminderFox Funktionen"],
               ["options#options",         "Einstellungen (Optionen)",  "Anpassen der ReminderFox Funktionen"],
               ["options#preferences",     "Voreinstellungen",  "Informationen &uuml;ber weitere Einstellungen -- f&uuml;r Fortgeschrittene Nutzer"]
            ]
         ]
      ],
      ['hr'],

      ["faqdetails",  "FAQ - H&auml;ufig gestellte Fragen",  "Fragen und Antworten"],
      ["problems",    "Fehlersituationen",  "Gibt es Probleme? Hier sind Antworten zu einigen Schwierigkeiten",
         [  ["problems",            "Fehlersituationen", "Gibt es Probleme? Hier sind Antworten zu einigen Schwierigkeiten"],
            ["problems#deinstall",  "ReminderFox deinstallieren.", "Hinweis zur vollst&auml;ndigen Deinstallation"]
         ]
      ],
      
      ["http://reminderfox.mozdev.org/list.html",   "ReminderFox List", "F&uuml;r weitere Fragen und Antworten: ReminderFox Liste."],
  ]
];
   
